<?php

/*
 * Сервисная страница
 * Используется реализации функционального интерфейса
 */

include $_SERVER['DOCUMENT_ROOT'] . '/app/configuration/init.php';

Modules\FrontEnd\App\Models\Web\WebRender::render(
    [
        'controller' => function () {

            /*
             * Если потребуется объект авторизованного пользователя, используйте метод:
             * $user = App\Models\Users\Users::authorizationController();
             * Метод проследит за приватностью раздела и вернет данные пользователя
             */

            return [
                'lang' => \Prologue\Framework\Language\Language::message(
                    \Prologue\Framework\Http\Router::getUrl() . 'language/message.php'
                ),
                /*
                 *  Если необходимо подключить js скрипты или css стили
                 *  Раскоментируйте код и добавьте корректные пути
                'js' => [
                    '/web/service-page/static/script.css'
                ],
                'css' => [
                    '/web/service-page/static/styles.css'
                ],
                */
                'includeHeader' => true,
            ];
        },
        /*
         * Шаблон страницы
         */
        'view' => function ($data) { ?>
            <template>
                <div class="app">
                    <div class="uni-container">
                        <h1><?= $data['lang']['title'] ?></h1>
                        <div class="js_contentBox"></div>
                    </div>
                </div>
            </template>
        <? },
        /*
         *  Клиентская часть сервисной страницы
         */
        'javascript' => function () { ?>
            <script>
                App = {
                    loadData: function () {

                    }
                };
                $(function () {
                    App.loadData();
                });
            </script>
        <? },
        /*
         * Стили сервисной страницы
         */
        'css' => function () { ?>
            <style>
                .app {

                }
            </style>
        <? }
    ]
);